
#define LATCH 2
#define DATA 0
#define CLK 1

// the setup function runs once when you press reset or power the board
void setup() {
  // initialize digital pin LED_BUILTIN as an output.
  pinMode(LATCH, OUTPUT);
  pinMode(DATA, OUTPUT);
  pinMode(CLK, OUTPUT);
}

void clk(){
  digitalWrite(CLK, HIGH);
  //delay(10);
  digitalWrite(CLK, LOW);
  //delay(10);
}

void latch(){
  digitalWrite(LATCH, HIGH);
  delay(10);
  digitalWrite(LATCH, LOW);
  delay(10);
}

void frame( int f[]){
  for(int i = 0; i < 8; i++){
    if(f[i] == 0){
        digitalWrite(DATA, LOW);   // turn the LED on (HIGH is the voltage level)
        clk();
    }else{
        digitalWrite(DATA, HIGH);   // turn the LED on (HIGH is the voltage level)
        clk();
    }
    
  }
  latch();
}

void half(int speed){
  int f1[] = {1,1,1,1,0,0,0,0};
  int f2[] = {0,0,0,0,1,1,1,1};

  frame(f1);
  delay(speed);
  frame(f2);
  delay(speed);
}

void doubleKaro(int speed){
  int f1[] = {1,1,0,0,1,1,0,0};
  int f2[] = {0,0,1,1,0,0,1,1};
  

  frame(f1);
  delay(speed);
  frame(f2);
  delay(speed);

}

void karo(int speed){
  int f1[] = {0,1,0,1,0,1,0,1};
  int f2[] = {1,0,1,0,1,0,1,0};
  

  frame(f1);
  delay(speed);
  frame(f2);
  delay(speed);

}



void loading(int speed){
  int f12[] = {0,0,0,0,0,0,0,0};
  int f11[] = {1,0,0,0,0,0,0,0};
  int f10[] = {1,1,0,0,0,0,0,0};
  int f9[] =  {1,1,1,0,0,0,0,0};
  int f8[] =  {1,1,1,1,0,0,0,0};
  int f7[] =  {0,1,1,1,1,0,0,0};
  int f6[] =  {0,0,1,1,1,1,0,0};
  int f5[] =  {0,0,0,1,1,1,1,0};
  int f4[] =  {0,0,0,0,1,1,1,1};
  int f3[] =  {0,0,0,0,0,1,1,1};
  int f2[] =  {0,0,0,0,0,0,1,1};
  int f1[] =  {0,0,0,0,0,0,0,1};
  

  frame(f1);
  delay(speed);
  frame(f2);
  delay(speed);
  frame(f3);
  delay(speed);
  frame(f4);
  delay(speed);
  frame(f5);
  delay(speed);
  frame(f6);
  delay(speed);
  frame(f7);
  delay(speed);
  frame(f8);
  delay(speed);
  frame(f9);
  delay(speed);
  frame(f10);
  delay(speed);
  frame(f11);
  delay(speed);
  frame(f12);
  delay(speed);
  
}

void springer(int speed){
  int f8[] = {1,0,0,0,0,0,0,0};
  int f7[] = {0,0,0,1,0,0,0,0};
  int f6[] = {0,0,0,0,0,0,1,0};
  int f5[] = {0,1,0,0,0,0,0,0};
  int f4[] = {0,0,0,0,1,0,0,0};
  int f3[] = {0,0,0,0,0,0,0,1};
  int f2[] = {0,0,1,0,0,0,0,0};
  int f1[] = {0,0,0,0,0,1,0,0};
  

  frame(f1);
  delay(speed);
  frame(f2);
  delay(speed);
  frame(f3);
  delay(speed);
  frame(f4);
  delay(speed);
  frame(f5);
  delay(speed);
  frame(f6);
  delay(speed);
  frame(f7);
  delay(speed);
  frame(f8);
  delay(speed);
}

void halfRotationCounterClockwise(int speed){
  int f8[] = {1,1,1,1,0,0,0,0};
  int f7[] = {0,1,1,1,1,0,0,0};
  int f6[] = {0,0,1,1,1,1,0,0};
  int f5[] = {0,0,0,1,1,1,1,0};
  int f4[] = {0,0,0,0,1,1,1,1};
  int f3[] = {1,0,0,0,0,1,1,1};
  int f2[] = {1,1,0,0,0,0,1,1};
  int f1[] = {1,1,1,0,0,0,0,1};
  

  frame(f1);
  delay(speed);
  frame(f2);
  delay(speed);
  frame(f3);
  delay(speed);
  frame(f4);
  delay(speed);
  frame(f5);
  delay(speed);
  frame(f6);
  delay(speed);
  frame(f7);
  delay(speed);
  frame(f8);
  delay(speed);
}


void clockwise(int speed){
  int f1[] = {1,0,0,0,0,0,0,0};
  int f2[] = {0,1,0,0,0,0,0,0};
  int f3[] = {0,0,1,0,0,0,0,0};
  int f4[] = {0,0,0,1,0,0,0,0};
  int f5[] = {0,0,0,0,1,0,0,0};
  int f6[] = {0,0,0,0,0,1,0,0};
  int f7[] = {0,0,0,0,0,0,1,0};
  int f8[] = {0,0,0,0,0,0,0,1};
  

  frame(f1);
  delay(speed);
  frame(f2);
  delay(speed);
  frame(f3);
  delay(speed);
  frame(f4);
  delay(speed);
  frame(f5);
  delay(speed);
  frame(f6);
  delay(speed);
  frame(f7);
  delay(speed);
  frame(f8);
  delay(speed);
}

// the loop function runs over and over again forever
void loop() {

  for( int i = 0; i < 5; i++){
    springer(50);
  }
  for( int i = 0; i < 5; i++){
    clockwise(50);
  }
  for( int i = 0; i < 5; i++){
    halfRotationCounterClockwise(50);
  }
  for( int i = 0; i < 5; i++){
    loading(50);
  }
  for( int i = 0; i < 5*4; i++){
    karo(100);
  }
  for( int i = 0; i < 5*4; i++){
    doubleKaro(100);
  }
 
}
