#!/usr/bin/python
import os
import json


with open("config"+os.sep+"records.json") as recordsFile:
    recordsJSON = json.load(recordsFile)
    recordsFile.close()

class Record:
    def __init__(self, jsonObj):
        self.name = jsonObj['name']
        self.minValue = jsonObj['minValue']
        self.maxValue = jsonObj['maxValue']
        self.description = jsonObj['description']

        if self.minValue > self.maxValue:
            raise Exception("MinValue muss kleiner sein als der MaxValue! Record %s" % self.name)



def getRecords():
    recordList = []
    for record in recordsJSON:
        recordList.append(Record(record))
    return recordList



#for r in getRecords():
#    print "%s %d %d %s" % (r.name, r.minValue, r.maxValue, r.description );
